-- T-SQL Window Function Deep Dive
-- 3 Running Totals
USE AdventureWorks2014;
GO
SELECT  SalesOrderID,OrderDate, CustomerID, TotalDue,
	SUM(TotalDue) OVER(PARTITION BY CustomerID 
		ORDER BY SalesOrderID) AS CustomerRunningTotal
FROM Sales.SalesOrderHeader SOH
ORDER BY CustomerID, OrderDate;



--Frames
/*
By default the frame is RANGE BETWEEN UNBOUNDED 
PRECEDING AND CURRENT ROW

But use ROW instead 

*/

/*
UNBOUNDED PRECEDING
UNBOUNDED FOLLOWING
CURRENT ROW
<integer value> FOLLOWING (ROWS only)
<integer value> PRECEDING (ROWS only)
*/

--Must specify frame for reverse running total!
SELECT  OrderDate, CustomerID, TotalDue,
	SUM(TotalDue) OVER(PARTITION BY CustomerID ORDER BY SalesOrderID 
		ROWS BETWEEN UNBOUNDED PRECEDING and CURRENT ROW) AS RunningTotal,
	SUM(TotalDue) OVER(PARTITION BY CustomerID ORDER BY SalesOrderID 
		ROWS BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING) AS ReverseTotal
FROM Sales.SalesOrderHeader SOH
ORDER BY CustomerID, OrderDate;

--Can abbreviate
SELECT  OrderDate, CustomerID, TotalDue,
	SUM(TotalDue) OVER(PARTITION BY CustomerID ORDER BY SalesOrderID 
		ROWS UNBOUNDED PRECEDING ) AS RunningTotal,
	SUM(TotalDue) OVER(PARTITION BY CustomerID ORDER BY SalesOrderID 
		ROWS BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING) AS ReverseTotal
FROM Sales.SalesOrderHeader SOH
ORDER BY CustomerID, OrderDate;

--Using range, the default, with a non-unique order by can give 
--unexpected results
SELECT CustomerID, OrderDate, SalesOrderID, TotalDue, 
	SUM(TotalDue) OVER(ORDER BY OrderDate) AS RunningTotal,
	SUM(TotalDue) OVER(ORDER BY OrderDate
		ROWS BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW) AS RunningTotalWithFrame
FROM Sales.SalesOrderHeader 
WHERE CustomerID ='11078';

--Solution: use unique order by
--or specify the frame


--Same problem with old method
SELECT CustomerID, SalesOrderID, OrderDate, TotalDue, 
	(SELECT SUM(TotalDue) 
	FROM Sales.SalesOrderHeader
	WHERE CustomerID = a.CustomerID
		AND OrderDate <= a.OrderDate) AS RunningTotal
FROM Sales.SalesOrderHeader a
WHERE CustomerID ='11078';


--specify a number of rows
SELECT CustomerID, OrderDate, SalesOrderID, TotalDue,
	SUM(TotalDue) 
	OVER(Partition by CustomerID ORDER BY SalesOrderID 
	ROWS BETWEEN 2 PRECEDING AND CURRENT ROW)  
	AS Prev2_Orders
FROM Sales.SalesOrderHeader
Order By CustomerID DESC;

--Rolling average
WITH Orders AS (
	SELECT OrderDate, Sum(OrderQty) AS OrderQty 
	FROM Sales.SalesOrderHeader AS SOH 
	INNER JOIN Sales.SalesOrderDetail AS SOD 
		ON SOH.SalesOrderID = SOD.SalesOrderID
	GROUP BY OrderDate)
SELECT OrderDate, OrderQty, AVG(OrderQty) OVER(ORDER BY OrderDate
	ROWS BETWEEN 5 PRECEDING AND 5 FOLLOWING) AS MovingAvg
FROM Orders
ORDER BY OrderDate;


